/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Function;
import com.sun.jna.FunctionResultContext$CallbackResultContext;
import com.sun.jna.Klass$JNIEnv;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.StructureWriteContext$MethodResultContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.Union$CallbackResultContext;
import com.sun.jna.Union$PointerType;
import com.sun.jna.WString;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import melotr.ConfigChangedHandler;
import melotr.MCDAEventListener;

public class Pointer {
    public static final Pointer NULL = null;
    protected long peer;

    public Pointer getPointer(long offset) {
        return Native.getPointer(this.peer + offset);
    }

    public void read(long offset, byte[] buf, int index, int length) {
        Native.read(this, this.peer, offset, buf, index, length);
    }

    public void setString(long offset, String value) {
        this.setString(offset, value, Native.getDefaultStringEncoding());
    }

    public char[] getCharArray(long offset, int arraySize) {
        char[] buf = new char[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public long[] getLongArray(long offset, int arraySize) {
        long[] buf = new long[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public static void nativeValue(Pointer p, long value) {
        p.peer = value;
    }

    public short getShort(long offset) {
        return Native.getShort(this, this.peer, offset);
    }

    public static long nativeValue(Pointer p) {
        return p == null ? 0L : p.peer;
    }

    public byte getByte(long offset) {
        return Native.getByte(this, this.peer, offset);
    }

    public float getFloat(long offset) {
        return Native.getFloat(this, this.peer, offset);
    }

    public void write(long bOff, Pointer[] buf, int index, int length) {
        for (int i = 0; i < length; ++i) {
            this.setPointer(bOff + (long)(i * Native.POINTER_SIZE), buf[index + i]);
        }
    }

    public void setMemory(long offset, long length, byte value) {
        Native.setMemory(this, this.peer, offset, length, value);
    }

    public String dump(long offset, int size) {
        int BYTES_PER_ROW = 4;
        String TITLE = MCDAEventListener.l(Union$PointerType.H("\u07dc\u4da3\u842b\u35a1\u6ce2\u82cc\ubb36\u3313\ubce7\u36fb\u3acd"));
        StringWriter sw = new StringWriter(MCDAEventListener.l(Union$PointerType.H("\u07dc\u4da3\u842b\u35a1\u6ce2\u82cc\ubb36\u3313\ubce7\u36fb\u3acd")).length() + 2 + size * 2 + size / 4 * 4);
        PrintWriter out = new PrintWriter(sw);
        out.println(MCDAEventListener.l(Union$PointerType.H("\u07dc\u4da3\u842b\u35a1\u6ce2\u82cc\ubb36\u3313\ubce7\u36fb\u3acd")));
        for (int i = 0; i < size; ++i) {
            byte b = this.getByte(offset + (long)i);
            if (i % 4 == 0) {
                out.print(MCDAEventListener.l(Union$PointerType.H("\u07ea")));
            }
            if (b >= 0 && b < 16) {
                out.print(MCDAEventListener.l(Union$PointerType.H("\u0781")));
            }
            out.print(Integer.toHexString(b & 0xFF));
            if (i % 4 != 3 || i >= size - 1) continue;
            out.println(MCDAEventListener.l(Union$PointerType.H("\u07ec")));
        }
        if (sw.getBuffer().charAt(sw.getBuffer().length() - 2) != ']') {
            out.println(MCDAEventListener.l(Union$PointerType.H("\u07ec")));
        }
        return sw.toString();
    }

    public void setInt(long offset, int value) {
        Native.setInt(this, this.peer, offset, value);
    }

    public String getWideString(long offset) {
        return Native.getWideString(this, this.peer, offset);
    }

    public void write(long offset, byte[] buf, int index, int length) {
        Native.write(this, this.peer, offset, buf, index, length);
    }

    public void clear(long size) {
        this.setMemory(0L, size, (byte)0);
    }

    public Pointer[] getPointerArray(long offset) {
        ArrayList<Pointer> array = new ArrayList<Pointer>();
        int addOffset = 0;
        Pointer p = this.getPointer(offset);
        while (p != null) {
            array.add(p);
            p = this.getPointer(offset + (long)(addOffset += Native.POINTER_SIZE));
        }
        return array.toArray(new Pointer[0]);
    }

    public void setDouble(long offset, double value) {
        Native.setDouble(this, this.peer, offset, value);
    }

    public int getInt(long offset) {
        return Native.getInt(this, this.peer, offset);
    }

    public Pointer[] getPointerArray(long offset, int arraySize) {
        Pointer[] buf = new Pointer[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public String[] getWideStringArray(long offset) {
        return this.getWideStringArray(offset, -1);
    }

    public float[] getFloatArray(long offset, int arraySize) {
        float[] buf = new float[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public void write(long offset, float[] buf, int index, int length) {
        Native.write(this, this.peer, offset, buf, index, length);
    }

    public void read(long offset, int[] buf, int index, int length) {
        Native.read(this, this.peer, offset, buf, index, length);
    }

    public String[] getStringArray(long offset, int length) {
        return this.getStringArray(offset, length, Native.getDefaultStringEncoding());
    }

    public NativeLong getNativeLong(long offset) {
        return new NativeLong(NativeLong.SIZE == 8 ? this.getLong(offset) : (long)this.getInt(offset));
    }

    public void read(long offset, long[] buf, int index, int length) {
        Native.read(this, this.peer, offset, buf, index, length);
    }

    Pointer() {
    }

    public void write(long offset, short[] buf, int index, int length) {
        Native.write(this, this.peer, offset, buf, index, length);
    }

    public void setLong(long offset, long value) {
        Native.setLong(this, this.peer, offset, value);
    }

    public String[] getStringArray(long offset, String encoding) {
        return this.getStringArray(offset, -1, encoding);
    }

    public void setNativeLong(long offset, NativeLong value) {
        if (NativeLong.SIZE == 8) {
            this.setLong(offset, value.longValue());
        } else {
            this.setInt(offset, value.intValue());
        }
    }

    public void read(long offset, char[] buf, int index, int length) {
        Native.read(this, this.peer, offset, buf, index, length);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return o instanceof Pointer && ((Pointer)o).peer == this.peer;
    }

    private /* synthetic */ void readArray(long offset, Object o, Class<?> cls) {
        int length = 0;
        length = Array.getLength(o);
        Object result = o;
        if (cls == Byte.TYPE) {
            this.read(offset, (byte[])result, 0, length);
        } else if (cls == Short.TYPE) {
            this.read(offset, (short[])result, 0, length);
        } else if (cls == Character.TYPE) {
            this.read(offset, (char[])result, 0, length);
        } else if (cls == Integer.TYPE) {
            this.read(offset, (int[])result, 0, length);
        } else if (cls == Long.TYPE) {
            this.read(offset, (long[])result, 0, length);
        } else if (cls == Float.TYPE) {
            this.read(offset, (float[])result, 0, length);
        } else if (cls == Double.TYPE) {
            this.read(offset, (double[])result, 0, length);
        } else if (Pointer.class.isAssignableFrom(cls)) {
            this.read(offset, (Pointer[])result, 0, length);
        } else if (Structure.class.isAssignableFrom(cls)) {
            Structure[] sarray = (Structure[])result;
            if (Structure.ByReference.class.isAssignableFrom(cls)) {
                Pointer[] parray = this.getPointerArray(offset, sarray.length);
                for (int i = 0; i < sarray.length; ++i) {
                    sarray[i] = Structure.updateStructureByReference(cls, sarray[i], parray[i]);
                }
            } else {
                Structure first = sarray[0];
                if (first == null) {
                    first = Structure.newInstance(cls, this.share(offset));
                    first.conditionalAutoRead();
                    sarray[0] = first;
                } else {
                    first.useMemory(this, (int)offset, true);
                    first.read();
                }
                Structure[] tmp = first.toArray(sarray.length);
                for (int i = 1; i < sarray.length; ++i) {
                    if (sarray[i] == null) {
                        sarray[i] = tmp[i];
                        continue;
                    }
                    sarray[i].useMemory(this, (int)(offset + (long)(i * sarray[i].size())), true);
                    sarray[i].read();
                }
            }
        } else if (NativeMapped.class.isAssignableFrom(cls)) {
            NativeMapped[] array = (NativeMapped[])result;
            NativeMappedConverter tc = NativeMappedConverter.getInstance(cls);
            int size = Native.getNativeSize(result.getClass(), result) / array.length;
            for (int i = 0; i < array.length; ++i) {
                Object value = this.getValue(offset + (long)(size * i), tc.nativeType(), array[i]);
                array[i] = (NativeMapped)tc.fromNative(value, new FromNativeContext(cls));
            }
        } else {
            throw new IllegalArgumentException(MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uc131\u8889\u9fcc\u6f20\u9da8\u96b1\ub8a6\u0ea0\u9a9b\u6981\u7761\u79c2\u8062\u5880\u4c08\u6e8d\u8065")) + cls + MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uc14d\u8884\u9fd1\u6f25\u9da2\u96f1\ub8a2\u0eeb\u9a99\u6992\u776f\u79d4\u8035\u58c0\u4c06\u6e91\u806b\u2640\u765e\u0ea2\uf301\ucfd6\uab32\u1ef1\u7138\ua443")));
        }
    }

    public int[] getIntArray(long offset, int arraySize) {
        int[] buf = new int[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public Pointer share(long offset, long sz) {
        if (offset == 0L) {
            return this;
        }
        return new Pointer(this.peer + offset);
    }

    public void setString(long offset, String value, String encoding) {
        byte[] data = Native.getBytes(value, encoding);
        this.write(offset, data, 0, data.length);
        this.setByte(offset + (long)data.length, (byte)0);
    }

    public void setPointer(long offset, Pointer value) {
        Native.setPointer(this, this.peer, offset, value != null ? value.peer : 0L);
    }

    public void read(long offset, Pointer[] buf, int index, int length) {
        for (int i = 0; i < length; ++i) {
            Pointer p = this.getPointer(offset + (long)(i * Native.POINTER_SIZE));
            Pointer oldp = buf[i + index];
            if (oldp != null && p != null && p.peer == oldp.peer) continue;
            buf[i + index] = p;
        }
    }

    public void setShort(long offset, short value) {
        Native.setShort(this, this.peer, offset, value);
    }

    public double getDouble(long offset) {
        return Native.getDouble(this, this.peer, offset);
    }

    public void write(long offset, char[] buf, int index, int length) {
        Native.write(this, this.peer, offset, buf, index, length);
    }

    public ByteBuffer getByteBuffer(long offset, long length) {
        return Native.getDirectByteBuffer(this, this.peer, offset, length).order(ByteOrder.nativeOrder());
    }

    public long indexOf(long offset, byte value) {
        return Native.indexOf(this, this.peer, offset, value);
    }

    public double[] getDoubleArray(long offset, int arraySize) {
        double[] buf = new double[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public void setByte(long offset, byte value) {
        Native.setByte(this, this.peer, offset, value);
    }

    public int hashCode() {
        return (int)((this.peer >>> 32) + (this.peer & 0xFFFFFFFFL));
    }

    public void write(long offset, double[] buf, int index, int length) {
        Native.write(this, this.peer, offset, buf, index, length);
    }

    public void setFloat(long offset, float value) {
        Native.setFloat(this, this.peer, offset, value);
    }

    public static final Pointer createConstant(long peer) {
        return new Opaque(peer);
    }

    private /* synthetic */ void writeArray(long offset, Object value, Class<?> cls) {
        if (cls == Byte.TYPE) {
            byte[] buf = (byte[])value;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Short.TYPE) {
            short[] buf = (short[])value;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Character.TYPE) {
            char[] buf = (char[])value;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Integer.TYPE) {
            int[] buf = (int[])value;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Long.TYPE) {
            long[] buf = (long[])value;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Float.TYPE) {
            float[] buf = (float[])value;
            this.write(offset, buf, 0, buf.length);
        } else if (cls == Double.TYPE) {
            double[] buf = (double[])value;
            this.write(offset, buf, 0, buf.length);
        } else if (Pointer.class.isAssignableFrom(cls)) {
            Pointer[] buf = (Pointer[])value;
            this.write(offset, buf, 0, buf.length);
        } else if (Structure.class.isAssignableFrom(cls)) {
            Structure[] sbuf = (Structure[])value;
            if (Structure.ByReference.class.isAssignableFrom(cls)) {
                Pointer[] buf = new Pointer[sbuf.length];
                for (int i = 0; i < sbuf.length; ++i) {
                    if (sbuf[i] == null) {
                        buf[i] = null;
                        continue;
                    }
                    buf[i] = sbuf[i].getPointer();
                    sbuf[i].write();
                }
                this.write(offset, buf, 0, buf.length);
            } else {
                Structure first = sbuf[0];
                if (first == null) {
                    sbuf[0] = first = Structure.newInstance(cls, this.share(offset));
                } else {
                    first.useMemory(this, (int)offset, true);
                }
                first.write();
                Structure[] tmp = first.toArray(sbuf.length);
                for (int i = 1; i < sbuf.length; ++i) {
                    if (sbuf[i] == null) {
                        sbuf[i] = tmp[i];
                    } else {
                        sbuf[i].useMemory(this, (int)(offset + (long)(i * sbuf[i].size())), true);
                    }
                    sbuf[i].write();
                }
            }
        } else if (NativeMapped.class.isAssignableFrom(cls)) {
            NativeMapped[] buf = (NativeMapped[])value;
            NativeMappedConverter tc = NativeMappedConverter.getInstance(cls);
            Class<?> nativeType = tc.nativeType();
            int size = Native.getNativeSize(value.getClass(), value) / buf.length;
            for (int i = 0; i < buf.length; ++i) {
                Object element = tc.toNative(buf[i], new ToNativeContext());
                this.setValue(offset + (long)(i * size), element, nativeType);
            }
        } else {
            throw new IllegalArgumentException(MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\u4c0f\u4cb6\u42f4\u1424\u6284\ub6e7\u070a\ucff4\u3717\ufa40\u6803\u8b87\u19e4\ued29\ud162\ue346\u98ba")) + cls + MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\u4c76\u4cbe\u42fc\u147e\u628e\ub6e2\u070e\ucfb5\u370a\ufa45\u685f\u8b86\u19fc\ued73\ud123\ue35d\u98e1\uc775\ufa9f\u0428\u55b8\ud494\u365b\u5a16")));
        }
    }

    public void write(long offset, int[] buf, int index, int length) {
        Native.write(this, this.peer, offset, buf, index, length);
    }

    public byte[] getByteArray(long offset, int arraySize) {
        byte[] buf = new byte[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public static final Pointer createConstant(int peer) {
        return new Opaque((long)peer & 0xFFFFFFFFL);
    }

    public String toString() {
        return MCDAEventListener.l(Klass$JNIEnv.n("\u1bef\ua103\uf6e6\u345b\u938b\u877a\uac8f\uaf7c\u1f78")) + Long.toHexString(this.peer);
    }

    public String[] getStringArray(long offset, int length, String encoding) {
        ArrayList<String> strings = new ArrayList<String>();
        int addOffset = 0;
        if (length != -1) {
            Pointer p = this.getPointer(offset + (long)addOffset);
            int count = 0;
            while (count++ < length) {
                String s = p == null ? null : (Union$PointerType.H("\u185e\u1e66\u9443\u3189\u38bc\u72bd\ubf87\u7d92\u6e7e\udfd8\uc8db\uefe2\u1903\u275c\u39da").equals(encoding) ? p.getWideString(0L) : p.getString(0L, encoding));
                strings.add(s);
                if (count >= length) continue;
                p = this.getPointer(offset + (long)(addOffset += Native.POINTER_SIZE));
            }
        } else {
            Pointer p;
            while ((p = this.getPointer(offset + (long)addOffset)) != null) {
                String s = Union$PointerType.H("\u185e\u1e66\u9443\u3189\u38bc\u72bd\ubf87\u7d92\u6e7e\udfd8\uc8db\uefe2\u1903\u275c\u39da").equals(encoding) ? p.getWideString(0L) : p.getString(0L, encoding);
                strings.add(s);
                addOffset += Native.POINTER_SIZE;
            }
        }
        return strings.toArray(new String[0]);
    }

    public void read(long offset, float[] buf, int index, int length) {
        Native.read(this, this.peer, offset, buf, index, length);
    }

    public void read(long offset, short[] buf, int index, int length) {
        Native.read(this, this.peer, offset, buf, index, length);
    }

    public void read(long offset, double[] buf, int index, int length) {
        Native.read(this, this.peer, offset, buf, index, length);
    }

    public void setWideString(long offset, String value) {
        Native.setWideString(this, this.peer, offset, value);
    }

    public void write(long offset, long[] buf, int index, int length) {
        Native.write(this, this.peer, offset, buf, index, length);
    }

    public String getString(long offset, String encoding) {
        return Native.getString(this, offset, encoding);
    }

    public Pointer(long peer) {
        this.peer = peer;
    }

    public String[] getWideStringArray(long offset, int length) {
        return this.getStringArray(offset, length, Union$PointerType.H("\u3805\uf5d6\ufc2c\u25ab\u2c54\uf413\u340c\u10b0\u75e8\u04bd\u3672\u9e1a\u980d\u8f57\ua212"));
    }

    public Pointer share(long offset) {
        return this.share(offset, 0L);
    }

    public void setString(long offset, WString value) {
        this.setWideString(offset, value == null ? null : value.toString());
    }

    public void setChar(long offset, char value) {
        Native.setChar(this, this.peer, offset, value);
    }

    public short[] getShortArray(long offset, int arraySize) {
        short[] buf = new short[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public String[] getStringArray(long offset) {
        return this.getStringArray(offset, -1, Native.getDefaultStringEncoding());
    }

    public long getLong(long offset) {
        return Native.getLong(this, this.peer, offset);
    }

    Object getValue(long offset, Class<?> type, Object currentValue) {
        Object result = null;
        if (Structure.class.isAssignableFrom(type)) {
            Structure s = (Structure)currentValue;
            if (Structure.ByReference.class.isAssignableFrom(type)) {
                s = Structure.updateStructureByReference(type, s, this.getPointer(offset));
            } else {
                s.useMemory(this, (int)offset, true);
                s.read();
            }
            result = s;
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            result = Function.valueOf(this.getInt(offset) != 0);
        } else if (type == Byte.TYPE || type == Byte.class) {
            result = this.getByte(offset);
        } else if (type == Short.TYPE || type == Short.class) {
            result = this.getShort(offset);
        } else if (type == Character.TYPE || type == Character.class) {
            result = Character.valueOf(this.getChar(offset));
        } else if (type == Integer.TYPE || type == Integer.class) {
            result = this.getInt(offset);
        } else if (type == Long.TYPE || type == Long.class) {
            result = this.getLong(offset);
        } else if (type == Float.TYPE || type == Float.class) {
            result = Float.valueOf(this.getFloat(offset));
        } else if (type == Double.TYPE || type == Double.class) {
            result = this.getDouble(offset);
        } else if (Pointer.class.isAssignableFrom(type)) {
            Pointer p = this.getPointer(offset);
            if (p != null) {
                Pointer oldp;
                Pointer pointer = oldp = currentValue instanceof Pointer ? (Pointer)currentValue : null;
                result = oldp == null || p.peer != oldp.peer ? p : oldp;
            }
        } else if (type == String.class) {
            Pointer p = this.getPointer(offset);
            result = p != null ? p.getString(0L) : null;
        } else if (type == WString.class) {
            Pointer p = this.getPointer(offset);
            result = p != null ? new WString(p.getWideString(0L)) : null;
        } else if (Callback.class.isAssignableFrom(type)) {
            Pointer fp = this.getPointer(offset);
            if (fp == null) {
                result = null;
            } else {
                Callback cb = (Callback)currentValue;
                Pointer oldfp = CallbackReference.getFunctionPointer(cb);
                if (!fp.equals(oldfp)) {
                    cb = CallbackReference.getCallback(type, fp);
                }
                result = cb;
            }
        } else if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(type)) {
            Pointer bp = this.getPointer(offset);
            if (bp == null) {
                result = null;
            } else {
                Pointer oldbp;
                Pointer pointer = oldbp = currentValue == null ? null : Native.getDirectBufferPointer((Buffer)currentValue);
                if (oldbp == null || !oldbp.equals(bp)) {
                    throw new IllegalStateException(MCDAEventListener.l(StructureWriteContext$MethodResultContext.u("\u0a4e\u2e76\ud441\u58a8\uc5e6\ue82d\ucfdb\u0588\uf7d0\u785e\u29f4\u71b0\u482e\ud093\ucabd\u1311\u638b\u88dd\u9a0b\u0ef9\u4893\uee46\u5d21\u6a86\u15e3\u430b\u87f5\u1d8b\u1ed7\uab3e\ud33e\uf409\u36c6\u16ed\ufadd\u781f\ud59b\u2ae1\uff89\u1663\u4e42\u3496\ubae5\u81ec\u2717\u9a40\ub3ec\u2e6a\ueb59")));
                }
                result = currentValue;
            }
        } else if (NativeMapped.class.isAssignableFrom(type)) {
            NativeMapped nm = (NativeMapped)currentValue;
            if (nm != null) {
                Object value = this.getValue(offset, nm.nativeType(), null);
                result = nm.fromNative(value, new FromNativeContext(type));
                if (nm.equals(result)) {
                    result = nm;
                }
            } else {
                NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
                Object value = this.getValue(offset, tc.nativeType(), null);
                result = tc.fromNative(value, new FromNativeContext(type));
            }
        } else if (type.isArray()) {
            result = currentValue;
            if (result == null) {
                throw new IllegalStateException(MCDAEventListener.l(StructureWriteContext$MethodResultContext.u("\u0a43\u2e72\ud44a\u58eb\uc5b2\ue86c\ucfd4\u05dd\uf7cd\u785f\u29fa\u71a1\u4829\ud097\ucaa3\u1319\u6385\u88dd\u9a4f\u0eb8\u48d2\uee50\u5d3a\u6a95\u15ff")));
            }
            this.readArray(offset, result, type.getComponentType());
        } else {
            throw new IllegalArgumentException(MCDAEventListener.l(StructureWriteContext$MethodResultContext.u("\u0a5f\u2e72\ud44e\u58eb\uc5fb\ue863\ucfdd\u05dd\uf786")) + type + MCDAEventListener.l(StructureWriteContext$MethodResultContext.u("\u0a21\u2e39\ud447\u58f3\uc5f3\ue86e\ucf94\u059e\uf7cf\u7852\u29f2\u71a9\u4837\ud0d8\ucaa8\u130d\u63d1\u88d8\u9a4a\u0ee2\u489d\uee5f\u5d33\u6a8a\u15f8\u4309\u87fd\u1dd1\u1ede\uab21")));
        }
        return result;
    }

    public char getChar(long offset) {
        return Native.getChar(this, this.peer, offset);
    }

    void setValue(long offset, Object value, Class<?> type) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            this.setInt(offset, Boolean.TRUE.equals(value) ? -1 : 0);
        } else if (type == Byte.TYPE || type == Byte.class) {
            this.setByte(offset, value == null ? (byte)0 : (Byte)value);
        } else if (type == Short.TYPE || type == Short.class) {
            this.setShort(offset, value == null ? (short)0 : (Short)value);
        } else if (type == Character.TYPE || type == Character.class) {
            this.setChar(offset, value == null ? (char)'\u0000' : ((Character)value).charValue());
        } else if (type == Integer.TYPE || type == Integer.class) {
            this.setInt(offset, value == null ? 0 : (Integer)value);
        } else if (type == Long.TYPE || type == Long.class) {
            this.setLong(offset, value == null ? 0L : (Long)value);
        } else if (type == Float.TYPE || type == Float.class) {
            this.setFloat(offset, value == null ? 0.0f : ((Float)value).floatValue());
        } else if (type == Double.TYPE || type == Double.class) {
            this.setDouble(offset, value == null ? 0.0 : (Double)value);
        } else if (type == Pointer.class) {
            this.setPointer(offset, (Pointer)value);
        } else if (type == String.class) {
            this.setPointer(offset, (Pointer)value);
        } else if (type == WString.class) {
            this.setPointer(offset, (Pointer)value);
        } else if (Structure.class.isAssignableFrom(type)) {
            Structure s = (Structure)value;
            if (Structure.ByReference.class.isAssignableFrom(type)) {
                this.setPointer(offset, s == null ? null : s.getPointer());
                if (s != null) {
                    s.autoWrite();
                }
            } else {
                s.useMemory(this, (int)offset, true);
                s.write();
            }
        } else if (Callback.class.isAssignableFrom(type)) {
            this.setPointer(offset, CallbackReference.getFunctionPointer((Callback)value));
        } else if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(type)) {
            Pointer p = value == null ? null : Native.getDirectBufferPointer((Buffer)value);
            this.setPointer(offset, p);
        } else if (NativeMapped.class.isAssignableFrom(type)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
            Class<?> nativeType = tc.nativeType();
            this.setValue(offset, tc.toNative(value, new ToNativeContext()), nativeType);
        } else if (type.isArray()) {
            this.writeArray(offset, value, type.getComponentType());
        } else {
            throw new IllegalArgumentException(MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\u356a\ube4e\u4908\ud7a0\u66b7\u4569\ua781\u3a41")) + type + MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\u3513\ube46\u4900\ud7fa\u66bd\u456c\ua785\u3a00\uec21\udddd\ucc9e\ub82f\uec04\u65eb\u8ad5\u7f15\u9e27\u4547\ud494\u9613\ucd40\ue3bf\uc4c6\ua118\u4062\ue154\u6d35")));
        }
    }

    public String getString(long offset) {
        return this.getString(offset, Native.getDefaultStringEncoding());
    }

    private static class Opaque
    extends Pointer {
        private final String MSG = ConfigChangedHandler.l(Union$CallbackResultContext.U("\u14e3\ua1e3\u2614\uf76e\ub470\u9b97\uc264\u0f78\u06f3\ued66\u0e6f\uae86\ue9c4\uf1b3\u4e9b\u6e1f\u6f36\ud1f8\udf89\u4f5d\u5cff\ud213\u3559\u07d2")) + this;

        @Override
        public void write(long bOff, byte[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, float[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, short[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String getWideString(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void clear(long size) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, double[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String getString(long bOff, String encoding) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, short[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, float[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public Pointer getPointer(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public float getFloat(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String dump(long offset, int size) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setWideString(long offset, String value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public ByteBuffer getByteBuffer(long offset, long length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public byte getByte(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setString(long offset, String value, String encoding) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public int getInt(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public long indexOf(long offset, byte value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public char getChar(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, double[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, Pointer[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public long getLong(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setPointer(long offset, Pointer value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setChar(long bOff, char value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setShort(long bOff, short value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, long[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setMemory(long offset, long size, byte value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, byte[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, char[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, Pointer[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setByte(long bOff, byte value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public Pointer share(long offset, long size) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, long[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, char[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setInt(long bOff, int value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, int[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setDouble(long bOff, double value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String toString() {
            return CallbackThreadInitializer.l(Union$PointerType.H("\u39ab\ue062\uea1d\ua157\uca40\u834d\ubc30\ub30d")) + Long.toHexString(this.peer);
        }

        private /* synthetic */ Opaque(long peer) {
            super(peer);
        }

        @Override
        public short getShort(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public double getDouble(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setLong(long bOff, long value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setFloat(long bOff, float value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, int[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }
    }
}

